﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameManager : MonoBehaviour
{
    #region EventArgs Classes
    public class GameStateChangedEventArgs : EventArgs
    {
        public Constants.GameState OldState { get; set; }
        public Constants.GameState NewState { get; set; }
    }

    public event EventHandler<GameStateChangedEventArgs> GameStateChanged;
    #endregion

    //Public editor variables
    public float EasyHiderTime = 180000;
    public float EasySeekerTime = 240000;
    public float MediumHiderTime = 120000;
    public float MediumSeekerTime = 180000;
    public float HardHiderTime = 60000;
    public float HardSeekerTime = 120000;
    public float HintCooldown = 10000;
    public float HintShowTime = 3000;

    public Constants.GameState GameState
    {
        get
        {
            return _GameState;
        }

        set
        {
            //Setup the event args, set the new value and send the event notification to all subscribers
            GameStateChangedEventArgs args = new GameStateChangedEventArgs();
            args.OldState = _GameState;
            args.NewState = value;
            _GameState = value;
            OnGameStateChanged(args);
        }
    }

    private Constants.GameState _GameState;

    private static GameManager _Instance;
    public static GameManager Instance
    {
        get
        {
            if (_Instance == null)
            {
                _Instance = FindObjectOfType<GameManager>();
            }

            return _Instance;
        }
    }

    private void Start()
    {
        GameState = Constants.GameState.Running;
    }
    
    void Update()
    {

    }

    private void OnGameStateChanged(GameStateChangedEventArgs e)
    {
        //Called when the game states and sends an event notification to all subscribers
        EventHandler<GameStateChangedEventArgs> handler = GameStateChanged;
        if(handler != null)
        {
            handler(this, e);
        }
    }
}
